#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>

using namespace std;

struct parPovezanihStanica {
    int pocetnaStanica;
    int krajnjaStanica;
};

bool jesuDuplikati(const parPovezanihStanica& a, const parPovezanihStanica& b) {
    return (a.pocetnaStanica == b.pocetnaStanica && a.krajnjaStanica == b.krajnjaStanica) ||
           (a.pocetnaStanica == b.krajnjaStanica && a.krajnjaStanica == b.pocetnaStanica);
}

// racunanje minimalne razdaljine izmedju dve stanice
int minimalnaRazdaljina(int pocetnaStanica, int krajnjaStanica, int brojStanica, const vector<parPovezanihStanica>& listaPovezanosti) {
    queue<int> red;
    vector<bool> poseceno(brojStanica, false);
    vector<int> razdaljina(brojStanica, 0);

    red.push(pocetnaStanica);
    poseceno[pocetnaStanica] = true;

    while (!red.empty()) {
        int trenutnaStanica = red.front();
        red.pop();

        if (trenutnaStanica == krajnjaStanica) {
            return razdaljina[trenutnaStanica];
        }

        for (const auto& povezanaStanica : listaPovezanosti) {
            if (povezanaStanica.pocetnaStanica == trenutnaStanica) {
                int povezanaStanicaIndex = povezanaStanica.krajnjaStanica;
                if (!poseceno[povezanaStanicaIndex]) {
                    red.push(povezanaStanicaIndex);
                    poseceno[povezanaStanicaIndex] = true;
                    razdaljina[povezanaStanicaIndex] = razdaljina[trenutnaStanica] + 1;
                }
            } else if (povezanaStanica.krajnjaStanica == trenutnaStanica) {
                int povezanaStanicaIndex = povezanaStanica.pocetnaStanica;
                if (!poseceno[povezanaStanicaIndex]) {
                    red.push(povezanaStanicaIndex);
                    poseceno[povezanaStanicaIndex] = true;
                    razdaljina[povezanaStanicaIndex] = razdaljina[trenutnaStanica] + 1;
                }
            }
        }
    }

    // Ako nije pronadena putanja od pocetne do krajnje stanice
    return -1;
}

int main() {
    // N - broj stanica, M - broj starih povezanih stanica, S - pocetna stanica, T - krajnja stanica
    int N, M, S, T;

    cin >> N >> M >> S >> T;

    vector<parPovezanihStanica> starePovezaneStanice(M);

    for (int i = 0; i < M; i++) {
        cin >> starePovezaneStanice[i].pocetnaStanica >> starePovezaneStanice[i].krajnjaStanica;
    }

    // racunanje novih linija koje su povezane, A i B su povezane ako postoji povezanost A i C i B i C(bilo koja pocetna)
    vector<parPovezanihStanica> novePovezaneStanice;

    for (int i = 0; i < M; i++) {
        for (int j = 0; j < M; j++) {
            if (i == j) continue;
            if (starePovezaneStanice[i].pocetnaStanica == starePovezaneStanice[j].pocetnaStanica) {
                parPovezanihStanica noviParPovezanihStanica;
                if (starePovezaneStanice[i].krajnjaStanica < starePovezaneStanice[j].krajnjaStanica) {
                    noviParPovezanihStanica.pocetnaStanica = starePovezaneStanice[i].krajnjaStanica;
                    noviParPovezanihStanica.krajnjaStanica = starePovezaneStanice[j].krajnjaStanica;
                } else {
                    noviParPovezanihStanica.pocetnaStanica = starePovezaneStanice[j].krajnjaStanica;
                    noviParPovezanihStanica.krajnjaStanica = starePovezaneStanice[i].krajnjaStanica;
                }
                novePovezaneStanice.push_back(noviParPovezanihStanica);
            }

            if (starePovezaneStanice[i].pocetnaStanica == starePovezaneStanice[j].krajnjaStanica) {
                parPovezanihStanica noviParPovezanihStanica;
                if (starePovezaneStanice[i].krajnjaStanica < starePovezaneStanice[j].pocetnaStanica) {
                    noviParPovezanihStanica.pocetnaStanica = starePovezaneStanice[i].krajnjaStanica;
                    noviParPovezanihStanica.krajnjaStanica = starePovezaneStanice[j].pocetnaStanica;
                } else {
                    noviParPovezanihStanica.pocetnaStanica = starePovezaneStanice[j].pocetnaStanica;
                    noviParPovezanihStanica.krajnjaStanica = starePovezaneStanice[i].krajnjaStanica;
                }
                novePovezaneStanice.push_back(noviParPovezanihStanica);
            }

            if (starePovezaneStanice[i].krajnjaStanica == starePovezaneStanice[j].pocetnaStanica) {
                parPovezanihStanica noviParPovezanihStanica;
                if (starePovezaneStanice[j].krajnjaStanica < starePovezaneStanice[i].pocetnaStanica) {
                    noviParPovezanihStanica.pocetnaStanica = starePovezaneStanice[j].krajnjaStanica;
                    noviParPovezanihStanica.krajnjaStanica = starePovezaneStanice[i].pocetnaStanica;
                } else {
                    noviParPovezanihStanica.pocetnaStanica = starePovezaneStanice[i].pocetnaStanica;
                    noviParPovezanihStanica.krajnjaStanica = starePovezaneStanice[j].krajnjaStanica;
                }
                novePovezaneStanice.push_back(noviParPovezanihStanica);
            }

            if (starePovezaneStanice[i].krajnjaStanica == starePovezaneStanice[j].krajnjaStanica) {
                parPovezanihStanica noviParPovezanihStanica;
                if (starePovezaneStanice[i].pocetnaStanica < starePovezaneStanice[j].pocetnaStanica) {
                    noviParPovezanihStanica.krajnjaStanica = starePovezaneStanice[i].pocetnaStanica;
                    noviParPovezanihStanica.pocetnaStanica = starePovezaneStanice[j].pocetnaStanica;
                } else {
                    noviParPovezanihStanica.krajnjaStanica = starePovezaneStanice[j].pocetnaStanica;
                    noviParPovezanihStanica.pocetnaStanica = starePovezaneStanice[i].pocetnaStanica;
                }
                novePovezaneStanice.push_back(noviParPovezanihStanica);
            }
        }
    }

    // spjanje starih i novih povezanih stanica u jedan niz
    vector<parPovezanihStanica> finalniNizPovezanihStanica = starePovezaneStanice;
    finalniNizPovezanihStanica.insert(finalniNizPovezanihStanica.end(), novePovezaneStanice.begin(), novePovezaneStanice.end());

    for (auto& element : finalniNizPovezanihStanica) {
        if (element.pocetnaStanica > element.krajnjaStanica) {
            swap(element.pocetnaStanica, element.krajnjaStanica);
        }
    }

    sort(finalniNizPovezanihStanica.begin(), finalniNizPovezanihStanica.end(), [](const parPovezanihStanica& a, const parPovezanihStanica& b) {
        if (a.pocetnaStanica != b.pocetnaStanica)
            return a.pocetnaStanica < b.pocetnaStanica;
        return a.krajnjaStanica < b.krajnjaStanica;
    });

    auto poslednji = unique(finalniNizPovezanihStanica.begin(), finalniNizPovezanihStanica.end(), jesuDuplikati);

    finalniNizPovezanihStanica.erase(poslednji, finalniNizPovezanihStanica.end());

    cout << minimalnaRazdaljina(S, T, finalniNizPovezanihStanica.size(), finalniNizPovezanihStanica) << endl;

    return 0;
}